/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.observers;

import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.NonNull;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.CompositeException;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SafeObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> downstream;
    Disposable upstream;
    boolean done;

    public SafeObserver(@NonNull Observer<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            try {
                this.downstream.onSubscribe(this);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.done = true;
                try {
                    d.dispose();
                }
                catch (Throwable e1) {
                    Exceptions.throwIfFatal(e1);
                    RxJavaPlugins.onError(new CompositeException(e, e1));
                    return;
                }
                RxJavaPlugins.onError(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void onNext(@NonNull T t) {
        if (this.done) {
            return;
        }
        if (this.upstream == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t == null) {
            NullPointerException ex = ExceptionHelper.createNullPointerException("onNext called with a null value.");
            try {
                this.upstream.dispose();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(ex, e1));
                return;
            }
            this.onError(ex);
            return;
        }
        try {
            this.downstream.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.upstream.dispose();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(e, e1));
                return;
            }
            this.onError(e);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptyDisposable.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
            return;
        }
        try {
            this.downstream.onError(ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
        }
    }

    @Override
    public void onError(@NonNull Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.downstream.onSubscribe(EmptyDisposable.INSTANCE);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(new CompositeException(t, npe, e));
                return;
            }
            try {
                this.downstream.onError(new CompositeException(t, npe));
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(new CompositeException(t, npe, e));
            }
            return;
        }
        if (t == null) {
            t = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
        }
        try {
            this.downstream.onError(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(new CompositeException(t, ex));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.downstream.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptyDisposable.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
            return;
        }
        try {
            this.downstream.onError(ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
        }
    }
}

